/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.view;

import javax.annotation.Nonnull;

public class Gravity {
    public static final int AXIS_SPECIFIED = 1;
    public static final int AXIS_PULL_BEFORE = 2;
    public static final int AXIS_PULL_AFTER = 4;
    public static final int AXIS_CLIP = 8;
    public static final int AXIS_X_SHIFT = 0;
    public static final int AXIS_Y_SHIFT = 4;
    public static final int TOP = 48;
    public static final int BOTTOM = 80;
    public static final int LEFT = 3;
    public static final int RIGHT = 5;
    public static final int TOP_LEFT = 51;
    public static final int TOP_RIGHT = 53;
    public static final int BOTTOM_LEFT = 83;
    public static final int BOTTOM_RIGHT = 85;
    public static final int VERTICAL_CENTER = 16;
    public static final int LEFT_CENTER = 19;
    public static final int RIGHT_CENTER = 21;
    public static final int FILL_VERTICAL = 112;
    public static final int HORIZONTAL_CENTER = 1;
    public static final int TOP_CENTER = 49;
    public static final int BOTTOM_CENTER = 81;
    public static final int FILL_HORIZONTAL = 7;
    public static final int CENTER = 17;
    public static final int FILL = 119;
    public static final int CLIP_VERTICAL = 128;
    public static final int CLIP_HORIZONTAL = 8;
    public static final int HORIZONTAL_GRAVITY_MASK = 7;
    public static final int VERTICAL_GRAVITY_MASK = 112;

    public static void apply(int gravity, int w, int h2, @Nonnull int[] container, int xAdj, int yAdj, int[] outRect) {
        if (container.length < 4 || outRect.length < 4) {
            throw new IllegalArgumentException();
        }
        switch (gravity & 6) {
            case 0: {
                outRect[0] = container[0] + (container[2] - container[0] - w) / 2 + xAdj;
                outRect[2] = outRect[0] + w;
                if ((gravity & 8) != 8) break;
                if (outRect[0] < container[0]) {
                    outRect[0] = container[0];
                }
                if (outRect[2] <= container[2]) break;
                outRect[2] = container[2];
                break;
            }
            case 2: {
                outRect[0] = container[0] + xAdj;
                outRect[2] = outRect[0] + w;
                if ((gravity & 8) != 8 || outRect[2] <= container[2]) break;
                outRect[2] = container[2];
                break;
            }
            case 4: {
                outRect[2] = container[2] - xAdj;
                outRect[0] = outRect[2] - w;
                if ((gravity & 8) != 8 || outRect[0] >= container[0]) break;
                outRect[0] = container[0];
                break;
            }
            default: {
                outRect[0] = container[0] + xAdj;
                outRect[2] = container[2] + xAdj;
            }
        }
        switch (gravity & 0x60) {
            case 0: {
                outRect[1] = container[1] + (container[3] - container[1] - h2) / 2 + yAdj;
                outRect[3] = outRect[1] + h2;
                if ((gravity & 0x80) != 128) break;
                if (outRect[1] < container[1]) {
                    outRect[1] = container[1];
                }
                if (outRect[3] <= container[3]) break;
                outRect[3] = container[3];
                break;
            }
            case 32: {
                outRect[1] = container[1] + yAdj;
                outRect[3] = outRect[1] + h2;
                if ((gravity & 0x80) != 128 || outRect[3] <= container[3]) break;
                outRect[3] = container[3];
                break;
            }
            case 64: {
                outRect[3] = container[3] - yAdj;
                outRect[1] = outRect[3] - h2;
                if ((gravity & 0x80) != 128 || outRect[1] >= container[1]) break;
                outRect[1] = container[1];
                break;
            }
            default: {
                outRect[1] = container[1] + yAdj;
                outRect[3] = container[3] + yAdj;
            }
        }
    }
}

